# 📚 Caderno de Erros - Guia de Deploy Hostinger

Este projeto é um leitor de notas em Markdown com interface web em PHP, pronto para hospedagem na Hostinger.

## 📁 Estrutura do Projeto

```
caderno de erros/
├── index.php          # Arquivo principal (lista e exibe notas/imagens)
├── style.css          # Estilos responsivos
├── .htaccess          # Configurações Apache (segurança e performance)
├── notas/             # Pasta com arquivos .md
│   ├── Highlights.md
│   ├── Planejar é a atividade inicial da a.md
│   ├── Realidade de goias - 2.md
│   ├── Realidade de goias.md
│   ├── o que o tribunal de contas pode faz.md
│   └── revisar o cofifomobi.md
├── img/               # Pasta com imagens de estudo
│   └── exemplo_direito_administrativo.png
└── README.md          # Este arquivo
```

## 🚀 Como Fazer Deploy na Hostinger

### 1. Preparar os Arquivos

Todos os arquivos já estão prontos no diretório `c:\Users\charl\Desktop\caderno de erros\`

### 2. Acessar o Painel da Hostinger

1. Faça login em [hpanel.hostinger.com](https://hpanel.hostinger.com)
2. Selecione sua hospedagem
3. Clique em **"Gerenciador de Arquivos"** ou **"File Manager"**

### 3. Upload dos Arquivos

#### Opção A: Via File Manager (Recomendado)
1. Navegue até a pasta `public_html` (ou a pasta raiz do seu domínio)
2. Clique em **"Upload"**
3. Selecione e envie todos os arquivos:
   - `index.php`
   - `style.css`
   - `.htaccess`
4. Crie a pasta `notas` (botão "New Folder")
5. Entre na pasta `notas` e faça upload de todos os arquivos `.md`
6. Volte para `public_html` e crie a pasta `img`
7. Entre na pasta `img` e faça upload das suas imagens de estudo

#### Opção B: Via FTP
1. Use um cliente FTP (FileZilla, WinSCP, etc.)
2. Conecte com as credenciais FTP da Hostinger
3. Navegue até `public_html`
4. Arraste todos os arquivos e a pasta `notas`

### 4. Configurar Permissões

As permissões padrão geralmente funcionam, mas se necessário:
- Arquivos PHP, CSS, MD: **644**
- Pasta `notas`: **755**
- Arquivo `.htaccess`: **644**

### 5. Verificar Versão do PHP

1. No hPanel, vá em **"PHP Configuration"** ou **"Configurações de PHP"**
2. Certifique-se de que está usando **PHP 7.4** ou superior (recomendado: PHP 8.0+)

### 6. Testar o Site

Acesse seu domínio no navegador:
- `https://seudominio.com` (se estiver na raiz)
- `https://seudominio.com/caderno` (se estiver em subpasta)

Você deverá ver a página principal com a lista de notas.

## ✨ Funcionalidades

- **📋 Lista de Notas**: Exibe todas as notas disponíveis em cards
- **🖼️ Galeria de Imagens**: Visualize e baixe imagens de estudo
- **🔍 Busca**: Campo de pesquisa para filtrar notas e imagens pelo título
- **📖 Visualização**: Clique em qualquer nota ou imagem para ver o conteúdo completo
- **⬇️ Download de Imagens**: Baixe imagens diretamente do navegador
- **📱 Responsivo**: Layout adaptável para desktop, tablet e celular
- **🎨 Design Moderno**: Interface limpa com gradientes e animações suaves
- **🔒 Seguro**: Proteção contra acesso direto aos arquivos .md e .txt

## 🔧 Personalização

### Alterar Cores
Edite as variáveis CSS no início do arquivo `style.css`:

```css
:root {
    --primary-color: #4f46e5;  /* Cor principal */
    --primary-dark: #3730a3;   /* Cor escura */
    /* ... */
}
```

### Adicionar Novas Notas
1. Crie um novo arquivo `.md` na pasta `notas`
2. Ele aparecerá automaticamente na lista

### Adicionar Imagens de Estudo
1. Faça upload de imagens (JPG, PNG, GIF, WebP, SVG, BMP) para a pasta `img`
2. Elas aparecerão automaticamente na aba "🖼️ Imagens"
3. Clique em qualquer imagem para visualizar em tela cheia
4. Use o botão "⬇️ Baixar Imagem" para fazer download

### Modificar Título
Edite a linha no `index.php`:
```php
<h1>📚 Caderno de Erros</h1>
```

## 🆘 Solução de Problemas

### Página em branco
- Verifique se o PHP está habilitado
- Confirme que a versão do PHP é 7.4+
- Verifique os logs de erro no hPanel

### Notas não aparecem
- Confirme que a pasta `notas` existe
- Verifique se os arquivos têm extensão `.md`
- Verifique permissões da pasta (755)

### Erro 500
- Verifique o arquivo `.htaccess`
- Pode comentar linhas do `.htaccess` uma por uma para identificar o problema

### Estilo não carrega
- Verifique se `style.css` está na mesma pasta que `index.php`
- Limpe o cache do navegador (Ctrl + F5)

## 📞 Suporte Hostinger

Em caso de problemas técnicos com a hospedagem:
- Chat ao vivo: Disponível 24/7 no hPanel
- Email: suporte@hostinger.com.br
- Base de conhecimento: [support.hostinger.com](https://support.hostinger.com)

## 📝 Notas Técnicas

- **Requisitos**: PHP 7.4+, Apache com mod_rewrite
- **Compatibilidade**: Totalmente compatível com Hostinger Shared Hosting
- **SSL**: Recomenda-se ativar SSL/HTTPS gratuito no hPanel
- **Performance**: Otimizado com cache e compressão GZIP

---

✅ **Pronto!** Seu caderno de erros está online e acessível de qualquer lugar!
